# SPBsurvival.R
# Multiple regression for SPB survival data

# Load necessary libraries
library(ggplot2)
library(car)
library(QuantPsyc)

# Read in data set
SPB <- read.table(header=T,colClasses=rep("numeric",3),text="
satkden blueden survival
1.250 0.000 0.107 
2.656 0.481 0.715 
7.334 0.171 0.036 
1.603 0.352 0.188 
2.622 0.016 0.438 
1.000 0.000 0.585 
4.342 0.185 0.115 
5.233 0.018 0.257 
2.500 0.410 0.032 
3.250 0.015 0.350 
6.000 0.007 0.161 
4.750 0.000 0.073 
2.500 0.095 0.219 
8.750 0.033 0.028 
6.000 0.015 0.294 
5.000 0.105 0.207 
7.149 0.025 0.227 
6.750 0.015 0.040 
7.500 0.043 0.089 
2.500 0.073 0.176 
5.000 0.055 0.084 
2.250 0.023 0.203 
1.250 0.123 0.074 
4.750 0.035 0.126 
4.500 0.212 0.290 
9.557 0.166 0.010 
5.000 0.338 0.207 
")

# Apply transformations here
SPB <- transform(SPB,y=log(survival))

# Print data
SPB

# Graphics using ggplot2
ggplot(SPB,aes(satkden,y))+
geom_point()+
stat_smooth(method="lm")
ggplot(SPB,aes(blueden,y))+
geom_point()+
stat_smooth(method="lm")

# Multiple regression
regout <- lm(y~satkden+blueden,data=SPB)
summary(regout)

# 95% confidence intervals for regression coefficients
confint(regout)

# Standardized regression coefficients
lm.beta(regout)

# Tolerance values (1/vif)
tol <- 1/vif(regout)
tol

# Variance inflation factors
vif(regout)

# Residual-residual plots
avPlots(regout)

# Diagnostic plots to check regression assumptions
p <- predict(regout)
r <- resid(regout)
plot(p,r)
qqnorm(r)
